unit Unit1;

{$MODE Delphi}

interface

uses
  LCLIntf, LCLType,  SysUtils, Controls, Forms, Dialogs,
  StdCtrls,Registry, ExtCtrls, Classes, ComCtrls, Grids, {DirOutln,}
  Menus, Graphics, Process;

type

  { TForm1 }

  TForm1 = class(TForm)
    Image2: TImage;
    Panel1: TPanel;
    Panel2: TPanel;
    Label1: TLabel;
    StaticText1: TStaticText;
    TreeView1: TTreeView;
    ImageList1: TImageList;
    Image1: TImage;
    Button1: TButton;
    PopupMenu1: TPopupMenu;
    Edit1: TMenuItem;
    Uninstall1: TMenuItem;
    Button2: TButton;
    OpenDialog1: TOpenDialog;
    procedure FormCreate(Sender: TObject);
    procedure TreeView1DblClick(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure Edit1Click(Sender: TObject);
    procedure PopupMenu1Popup(Sender: TObject);
    procedure Uninstall1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure FormKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);

  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;
  A_Name, A_Source, A_Path : Tstrings;
  MyTreeNode, NoTreeNode: TTreeNode;
  ValueStr, PathStr: String;
  Aprocess: TProcess;

implementation

uses Unit2;

{$R *.lfm}
procedure FillForm(desc,par,src: string); forward;
procedure TForm1.FormCreate(Sender: TObject);


var
   WorkReg, TheReg: TRegistry;
   KeyName: String;
   NewKey: String;
   List: TStrings;
   I: Integer;


begin
   TheReg := TRegistry.Create;
   WorkReg := TRegistry.Create;
   TheReg.RootKey := HKEY_LOCAL_MACHINE;
   WorkReg.RootKey := HKEY_LOCAL_MACHINE;
   KeyName := 'Software\Microsoft\Windows\CurrentVersion\Uninstall';
   List := TStringList.Create;
   A_Name := TStringList.Create;
   A_Source := TStringList.Create;
   A_Path := TStringList.Create;
   MyTreeNode := TreeView1.Items[0];
   NoTreeNode := TreeView1.Items[1];
   Aprocess := TProcess.Create(nil);

   try
      if TheReg.OpenKey(KeyName, False) then
      begin
         TheReg.GetKeyNames(List);
         TheReg.CloseKey;
         for I := 0 to list.Count - 1 do
          begin
          NewKey := KeyName + '\' + List[I];
          if WorkReg.OpenKey(NewKey, False) then
           begin
             ValueStr := WorkReg.ReadString('DisplayName');
             PathStr := WorkReg.ReadString('UninstallString');
             if (ValueStr <> '') and (PathStr <> '') then
              begin
              TreeView1.Items.AddChild(MyTreeNode, ValueStr);
              A_name.add(ValueStr);
              A_Source.add(List[I]);
              A_path.add(PathStr);
              end;
            WorkReg.CloseKey;
           end;
         end;      //end of for loop
        for I := 0 to list.Count - 1 do
          begin
          NewKey := KeyName + '\' + List[I];
          if WorkReg.OpenKey(NewKey, False) then
           begin
             ValueStr := WorkReg.ReadString('DisplayName');
             PathStr := WorkReg.ReadString('UninstallString');
             if (ValueStr = '') and (PathStr = '') then
              begin
              TreeView1.Items.AddChild(NoTreeNode,List[I]);
              A_name.add(List[I]);
              A_Source.add(List[I]);
            end;
            WorkReg.CloseKey;
           end;
         end;      //end of for loop

       end;
     finally
        TheReg.Free;
        WorkReg.Free;
 end;

 Treeview1.Items[0].Expand(true);

end;


procedure TForm1.TreeView1DblClick(Sender: TObject);
begin
  if  (TreeView1.Selected.Level <> 0) and (TreeView1.Selected.Parent <> NoTreeNode) then
  begin
  Aprocess.CommandLine := A_Path[TreeView1.Selected.Index];
  Aprocess.Execute;
  //WinExec(Pchar(A_Path[TreeView1.Selected.Index]),SW_SHOWNORMAL);
  end else
    ShowMessage('There is no uninstall command')
end;

procedure FillForm(desc,par,src: string);
begin
 Form2.Edit1.Text := desc;
 Form2.Edit2.Text := par;
 Form2.Label4.Caption := src;
 //Form2.Left := 130;
 //Form2.Top  := 295;
 Form2.ShowModal();
end;

procedure TForm1.Button1Click(Sender: TObject);
begin
  if TreeView1.Selected.Parent.Text = 'Not Exposed to User' then
    begin
     FillForm(A_Name[TreeView1.Selected.AbsoluteIndex-2],'There is no command', A_Source[TreeView1.Selected.AbsoluteIndex-2]);
    end
    else
    begin
     FillForm(A_Name[TreeView1.Selected.AbsoluteIndex-1],A_Path[TreeView1.Selected.AbsoluteIndex-1], A_Source[TreeView1.Selected.AbsoluteIndex-1]);
    end;
end;

procedure TForm1.Edit1Click(Sender: TObject);
begin
  if TreeView1.Selected.Parent.Text = 'Not Exposed to User' then
    begin
     FillForm(A_Name[TreeView1.Selected.AbsoluteIndex-2],'There is no command', A_Source[TreeView1.Selected.AbsoluteIndex-2]);
    end
    else
    begin
     FillForm(A_Name[TreeView1.Selected.AbsoluteIndex-1],A_Path[TreeView1.Selected.AbsoluteIndex-1], A_Source[TreeView1.Selected.AbsoluteIndex-1]);
    end;
end;

procedure TForm1.PopupMenu1Popup(Sender: TObject);
begin
if  (TreeView1.Selected.Level = 0) then
 begin
 Edit1.Enabled := False;
 Uninstall1.Enabled := False;
 end
else
 begin
 Edit1.Enabled := True;
 Uninstall1.Enabled := True;
 end;
end;

procedure TForm1.Uninstall1Click(Sender: TObject);
begin
  if TreeView1.Selected.Parent.Text = 'Not Exposed to User' then
    ShowMessage('There is no uninstall command')
   else
      begin
     Aprocess.CommandLine := A_Path[TreeView1.Selected.Index];
     Aprocess.Execute;
     //WinExec(Pchar(A_Path[TreeView1.Selected.Index]),SW_SHOWNORMAL);
  end;
end;

procedure TForm1.Button2Click(Sender: TObject);
var
I: Integer;
begin
OpenDialog1.Title := 'Choose program to install...';
 OpenDialog1.Filter := 'Programs (*.exe)|*.exe';
  if OpenDialog1.Execute then
  with OpenDialog1.Files do
    for I := 0 to Count - 1 do
     begin
     Aprocess.CommandLine := OpenDialog1.Files.Strings[I];
     Aprocess.Execute;
     //WinExec(Pchar(OpenDialog1.Files.Strings[I]),SW_SHOWNORMAL);
      Continue;
  end;
 end;

procedure TForm1.FormKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
    if key = 27 then
     Application.Terminate;
end;

end.
