Name "crcutil"
OutFile redist\crcutil21.exe
CRCCheck on
LicenseText "You must read the following before installing."
LicenseData crcutil-license.txt
ComponentText "This will install the CRCutil on your computer."
InstType Normal
DirText "Please select a location to install crcutil (or use the default)."
UninstallText "This will uninstall crcutil from your system."

InstallDir "$PROGRAMFILES\Costain-Tech\crcutil"
InstallDirRegKey HKEY_LOCAL_MACHINE SOFTWARE\crcutil ""

Section "crcutil Program Files (required)"
SectionIn 1
SetOutPath $INSTDIR
File crcutil.exe
CreateShortCut "$DESKTOP\CRCutil.lnk" "$INSTDIR\crcutil.exe" "" "" 0
WriteUninstaller "uninstall.exe" 
SectionEnd

Section "crcutil Source Code"
SetOutPath "$INSTDIR\Source\"
File Source\*.*
SectionEnd

Section -post
WriteRegStr HKEY_LOCAL_MACHINE SOFTWARE\crcutil "" $INSTDIR
WriteRegStr HKEY_LOCAL_MACHINE "Software\Microsoft\Windows\CurrentVersion\Uninstall\crcutil" "DisplayName" "Crcutil (remove only)"
WriteRegStr HKEY_LOCAL_MACHINE "Software\Microsoft\Windows\CurrentVersion\Uninstall\crcutil" "UninstallString" '"$INSTDIR\uninstall.exe"'
SectionEnd

Section Uninstall
DeleteRegKey HKEY_LOCAL_MACHINE "Software\Microsoft\Windows\CurrentVersion\Uninstall\crcutil"
DeleteRegKey HKEY_LOCAL_MACHINE SOFTWARE\crcutil
Delete "$INSTDIR\crcutil.exe"
Delete "$DESKTOP\CRCutil.lnk"
Delete "$INSTDIR\Source\*.*"
RMDir "$INSTDIR\Source"
RMDir "$INSTDIR"
SectionEnd